package com.ejie.ab04b.service.eventos;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.dao.eventos.ErrorEventoColaDao;
import com.ejie.ab04b.model.eventos.ErrorEventoCola;
import com.ejie.x38.dto.JQGridRequestDto;

/**
 * ErrorEventoColaServiceImpl generated by UDA, 26-sep-2013 8:23:19.
 * 
 * @author UDA
 */

@Service(value = "errorEventoColaService")
public class ErrorEventoColaServiceImpl implements ErrorEventoColaService {

	@Autowired()
	private ErrorEventoColaDao errorEventoColaDao;

	/**
	 * Inserts a single row in the ErrorEventoCola table.
	 * 
	 *  errorEventoCola
	 *            ErrorEventoCola
	 *  ErrorEventoCola
	 *
	 * @param errorEventoCola the error evento cola
	 * @return the error evento cola
	 */
	@Transactional(isolation = Isolation.READ_COMMITTED, propagation = Propagation.REQUIRED, rollbackFor = Throwable.class)
	public ErrorEventoCola add(ErrorEventoCola errorEventoCola) {
		return this.errorEventoColaDao.add(errorEventoCola);
	}

	/**
	 * Updates a single row in the ErrorEventoCola table.
	 * 
	 *  errorEventoCola
	 *            ErrorEventoCola
	 *  ErrorEventoCola
	 *
	 * @param errorEventoCola the error evento cola
	 * @return the error evento cola
	 */
	@Transactional(isolation = Isolation.READ_COMMITTED, propagation = Propagation.REQUIRED, rollbackFor = Throwable.class)
	public ErrorEventoCola update(ErrorEventoCola errorEventoCola) {
		return this.errorEventoColaDao.update(errorEventoCola);
	}

	/**
	 * Finds a single row in the ErrorEventoCola table.
	 * 
	 *  errorEventoCola
	 *            ErrorEventoCola
	 *  ErrorEventoCola
	 *
	 * @param errorEventoCola the error evento cola
	 * @return the error evento cola
	 */
	@Transactional(isolation = Isolation.READ_COMMITTED, propagation = Propagation.NOT_SUPPORTED)
	public ErrorEventoCola find(ErrorEventoCola errorEventoCola) {
		return (ErrorEventoCola) this.errorEventoColaDao.find(errorEventoCola);
	}

	/**
	 * Finds a List of rows in the ErrorEventoCola table.
	 * 
	 *  errorEventoCola
	 *            ErrorEventoCola
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  List
	 *
	 * @param errorEventoCola the error evento cola
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	@Transactional(isolation = Isolation.READ_COMMITTED, propagation = Propagation.NOT_SUPPORTED)
	public List<ErrorEventoCola> findAll(ErrorEventoCola errorEventoCola, JQGridRequestDto jqGridRequestDto) {
		return (List<ErrorEventoCola>) this.errorEventoColaDao.findAll(errorEventoCola, jqGridRequestDto);
	}

	/**
	 * Counts rows in the ErrorEventoCola table.
	 * 
	 *  errorEventoCola
	 *            ErrorEventoCola
	 *  Long
	 *
	 * @param errorEventoCola the error evento cola
	 * @return the long
	 */
	@Transactional(isolation = Isolation.READ_COMMITTED, propagation = Propagation.NOT_SUPPORTED)
	public Long findAllCount(ErrorEventoCola errorEventoCola) {
		return this.errorEventoColaDao.findAllCount(errorEventoCola);
	}

	/**
	 * Deletes a single row in the ErrorEventoCola table.
	 * 
	 *  errorEventoCola
	 *            ErrorEventoCola
	 *
	 * @param errorEventoCola the error evento cola
	 */
	@Transactional(isolation = Isolation.READ_COMMITTED, propagation = Propagation.REQUIRED, rollbackFor = Throwable.class)
	public void remove(ErrorEventoCola errorEventoCola) {
		this.errorEventoColaDao.remove(errorEventoCola);
	}

}
